-- SUBQUERIES --
-- subquery'ler parantez ierisinde yazlr
-- where ksmnda eer subquery sonucunda 1 sonu dnyorsa =, birden ok sonu dnyorsa in kullanlmaldr
-- maksimum gie yapan filmlerin ynetmenlerini getir
use Filmler
select * from film
select max(gisesi) from film
select * from film where gisesi = 1000000.00
select * from film where gisesi = (select max(gisesi) from film) -- = kullanyoruz nk mutlaka tek sonu dner
select * from yonetmen where id = 1 or id = 4
select * from yonetmen where id in (1, 4)
select yonetmen_id from film where gisesi = (select max(gisesi) from film)
select * from yonetmen where id in (select yonetmen_id from film where gisesi = (select max(gisesi) from film)) -- sonu sorgusu: in kullanyoruz nk farkl ynetmenlerin ayn maksimum gieye sahip filmleri olabilir



-- ynetmen adlar ile birlikte filmleri getir
select * from film
select * from yonetmen
select id, adi, yapimyili, gisesi from film
select id, adi, yapimyili, gisesi, (select adi + ' ' + soyadi from yonetmen where yonetmen.id = film.yonetmen_id) yonetmeni from film -- sonu sorgusu



select Oyuncu.adi + ' ' + Oyuncu.soyadi as oyuncu from Oyuncu
where Oyuncu.id = 
(
	select top 1 FilmOyuncuKarakter.oyuncu_id from FilmOyuncuKarakter
	where FilmOyuncuKarakter.film_id = 
	(
		select Film.id from Film 
		where Film.gisesi = 
		(
			select MAX(Film.gisesi) from Film
		)
	)
)
-- En ok gie yapan filmin oyuncularndan ilk sradakini getir.
-- Burda subquery'lerden birinden birden ok deer dnyor. Bu sorunu ya top 1 diyip
-- ilk sradaki oyuncu id'sini alarak zebiliriz veya where clause'undaki ='ler yerine
-- in kullanabiliriz.



select Oyuncu.adi + ' ' + Oyuncu.soyadi as oyuncu from Oyuncu
where Oyuncu.id in 
(
	select FilmOyuncuKarakter.oyuncu_id from FilmOyuncuKarakter
	where FilmOyuncuKarakter.film_id in 
	(
		select Film.id from Film 
		where Film.gisesi = 
		(
			select MAX(Film.gisesi) from Film
		)
	)
)
-- En ok gie yapan filmin tm oyuncularn getir.
-- Eer bir tabloda iki primary key varsa, bu primary key'lerin olduu iki stunu tek bir
-- stunmu gibi dnebiliriz. Yani bu tabloda primary key olan ilk stun ile beraber 
-- primary key olan ikinci stunda ayn verilere sahip hibir satr yoktur.
-- Eer birden ok satr ieren bir tablo dnyorsa subquery'de, 
-- in kullanarak sorunu ortadan kaldrabiliyoruz. Tek satr dneceinden emin olmadmz 
-- tm subquery'lerde in kullanmak mantkl ve doru.



select f.id as filmid, f.adi as filmadi, 
(
	select y.adi + ' ' + y.soyadi from Yonetmen as y where f.yonetmen_id = y.id
) as filmyonetmeni from Film as f
-- Her bir satrda filmin id'sini, filmin adn ve o filme ait ynetmeni getirir.
select f.id as filmid, f.adi as filmadi, f.yapimyili as filmyapimyili, f.gisesi as filmgisesi, 
(
	select y.adi from Yonetmen as y where f.yonetmen_id = y.id
) as filmyonetmenadi, 
(
	select y.soyadi from Yonetmen as y where f.yonetmen_id = y.id
) as filmyonetmensoyadi
from Film as f
-- Her bir satrda filmin id'sini, filmin adn, filmin yapm yln, filmin giesini, 
-- filmin ynetmen adn ve filmin ynetmen soyadn getirir.



select o.soyadi + ', ' + o.adi as oyuncu from Oyuncu as o
where o.id in 
(
	select fok.oyuncu_id from FilmOyuncuKarakter as fok
	where fok.film_id =
	(
		select f.id from Film as f
		where f.adi = 'Avatar'
	)
)
-- Avatar filminin oyuncularn getir.
-- as ile alias tanmlama ilemi tablolar iin de yaplabilir,
-- alias tanmlandktan sonra o tabloya alias' zerinden de ulalabilir.